<?php

use App\Http\Controllers\SuperAdmin\AJAXController;
use App\Http\Controllers\SuperAdmin\ArchiveCategoriesController;
use App\Http\Controllers\SuperAdmin\Auth\ForgotPasswordController;
use App\Http\Controllers\SuperAdmin\Auth\LoginController;
use App\Http\Controllers\SuperAdmin\RolesController;
use App\Http\Controllers\SuperAdmin\UsersController;
use App\Http\Controllers\SuperAdmin\CustomersController;
use App\Http\Controllers\SuperAdmin\DashboardController;
use App\Http\Controllers\SuperAdmin\GeneralSettingsController;
use App\Http\Controllers\SuperAdmin\ProfileController;
use App\Http\Controllers\SuperAdmin\BlogCategoriesController;
use App\Http\Controllers\SuperAdmin\CitiesController;
use App\Http\Controllers\SuperAdmin\CompanyPagesController;
use App\Http\Controllers\SuperAdmin\CountriesController;
use App\Http\Controllers\SuperAdmin\FAQCategoriesController;
use App\Http\Controllers\SuperAdmin\EventsController;
use App\Http\Controllers\SuperAdmin\FAQSController;
use App\Http\Controllers\SuperAdmin\LanguagesController;
use App\Http\Controllers\SuperAdmin\StatesController;
use App\Http\Controllers\SuperAdmin\PricingPlansController;
use App\Http\Controllers\SuperAdmin\TagsController;
use App\Http\Controllers\SuperAdmin\TestimonialsController;
use App\Http\Controllers\SuperAdmin\PagesContentsController;
use App\Http\Controllers\SuperAdmin\ContactsController;
use App\Http\Controllers\SuperAdmin\PostsController;
use App\Http\Controllers\SuperAdmin\ArchivesController;
use App\Http\Controllers\SuperAdmin\PodcastsController;
use App\Http\Controllers\SuperAdmin\BroadcastsController;
use App\Http\Controllers\SuperAdmin\BroadcastCategoriesController;
use App\Http\Controllers\SuperAdmin\EventCategoriesController;
use App\Http\Controllers\SuperAdmin\PodcastCategoriesController;
use App\Http\Controllers\SuperAdmin\BookedAppointmentsController;
use App\Http\Controllers\SuperAdmin\CommissionSettingsController;
use App\Http\Controllers\SuperAdmin\CurruncyController;
use App\Http\Controllers\SuperAdmin\GatewaysController;
//TherapistCommunity
use App\Http\Controllers\SuperAdmin\TherapistCommunityCategoriesController;
use App\Http\Controllers\SuperAdmin\TherapistCommunityMainCategoriesController;
use App\Http\Controllers\SuperAdmin\TherapistCommunitysController;
use App\Http\Controllers\SuperAdmin\TherapistCommunityPostsController;
use App\Http\Controllers\SuperAdmin\TherapistCommunityEventsController;
use App\Http\Controllers\SuperAdmin\TherapistCommunityCertificationsController;
use App\Http\Controllers\SuperAdmin\TherapistCommunityBroadcastsController;
use App\Http\Controllers\SuperAdmin\TherapistCommunityPodcastsController;
use App\Http\Controllers\SuperAdmin\TherapistCommunityArchivesController;
//TherapistCommunity
//Therapist
use App\Http\Controllers\SuperAdmin\TherapistPostsController;
use App\Http\Controllers\SuperAdmin\TherapistEventsController;
use App\Http\Controllers\SuperAdmin\TherapistEducationsController;
use App\Http\Controllers\SuperAdmin\TherapistExperiencesController;
use App\Http\Controllers\SuperAdmin\TherapistCertificationsController;
use App\Http\Controllers\SuperAdmin\TherapistBroadcastsController;
use App\Http\Controllers\SuperAdmin\TherapistPodcastsController;
use App\Http\Controllers\SuperAdmin\TherapistArchivesController;
use App\Http\Controllers\SuperAdmin\TherapistCategoriesController;
use App\Http\Controllers\SuperAdmin\TherapistMainCategoriesController;
use App\Http\Controllers\SuperAdmin\TherapistsController;
use App\Http\Controllers\NotificationSettingsController;
use App\Http\Controllers\SuperAdmin\AppCarouselsController;
use App\Http\Controllers\SuperAdmin\BankAccountsController;
use App\Http\Controllers\SuperAdmin\BankTransactionsController;
use App\Http\Controllers\SuperAdmin\PaymentMethodsController;
use App\Http\Controllers\SuperAdmin\VersionUpgradesController;
use App\Http\Controllers\SuperAdmin\ServiceCategoriesController;
use App\Http\Controllers\SuperAdmin\ServicesController;
use App\Http\Controllers\SuperAdmin\SystemInformationsController;
use App\Http\Controllers\SuperAdmin\ThemeSettingsController;
use App\Http\Controllers\SuperAdmin\WithdrawRequestsController;
use App\Models\AppCarousel;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::middleware('guest')->prefix('super_admin')->name('super_admin.')->group(function () {
    Route::post('login', [LoginController::class, 'login'])->name('submit_login');
    Route::get('login', [LoginController::class, 'showLoginForm'])->name('login');
    Route::get('reset_password', [ForgotPasswordController::class, 'showResetPasswordForm'])->name('reset_password');
    Route::get('forgot_password', [ForgotPasswordController::class, 'showForgotPasswordForm'])->name('forgot_password');
    Route::post('submit_reset_password', [ForgotPasswordController::class, 'submitResetPasswordForm'])->name('submit_reset_password');
    Route::post('submit_forgot_password', [ForgotPasswordController::class, 'submitForgotPasswordForm'])->name('submit_forgot_password');
});

Route::middleware(['auth', 'super_admin'])->prefix('super_admin')->name('super_admin.')->group(function () {
    Route::post('logout', [LoginController::class, 'logout'])->name('logout');
    Route::get('dashboard', [DashboardController::class, 'home'])->name('dashboard');
    Route::resource('users', UsersController::class);
    Route::crudRoutes('customers', CustomersController::class);
    Route::crudRoutes('therapists', TherapistsController::class);
    Route::get('therapists/blogs/{therapist}', [TherapistsController::class, 'viewBlogs'])->name('therapists.blog');
    Route::get('therapists/events/{therapist}', [TherapistsController::class, 'viewEvents'])->name('therapists.event');
    Route::put('therapists/{therapist}/approve', [TherapistsController::class, 'approve'])->name('therapists.approve');
    Route::put('therapists-bulk/{type}', [TherapistsController::class, 'bulkActionTherapists'])->name('therapists.bulk');
    Route::crudRoutes('therapist_communitys', TherapistCommunitysController::class);
    Route::put('therapist_communitys/{therapist_community}/approve', [TherapistCommunitysController::class, 'approve'])->name('therapist_communitys.approve');
    Route::put('therapist_communitys-bulk/{type}', [TherapistCommunitysController::class, 'bulkActionTherapistCommunitys'])->name('therapist_communitys.bulk');
    Route::crudRoutes('events', EventsController::class);
    Route::put('events/{event}/approve', [EventsController::class, 'approve'])->name('events.approve');

    Route::crudRoutes('tags', TagsController::class);
    Route::crudRoutes('testimonials', TestimonialsController::class);
    Route::crudRoutes('company_pages', CompanyPagesController::class);
    Route::crudRoutes('therapist_categories', TherapistCategoriesController::class);
    Route::crudRoutes('therapist_main_categories', TherapistMainCategoriesController::class);
    Route::crudRoutes('therapist_community_categories', TherapistCommunityCategoriesController::class);
    Route::crudRoutes('therapist_community_main_categories', TherapistCommunityMainCategoriesController::class);
    Route::crudRoutes('blog_categories', BlogCategoriesController::class);
    Route::crudRoutes('event_categories', EventCategoriesController::class);
    Route::crudRoutes('faq_categories', FAQCategoriesController::class);
    Route::crudRoutes('podcast_categories', PodcastCategoriesController::class);
    Route::crudRoutes('service_categories', ServiceCategoriesController::class);
    Route::crudRoutes('services', ServicesController::class);
    Route::put('services/{service}/approve', [ServicesController::class, 'approve'])->name('services.approve');
    Route::put('services-bulk/{type}', [ServicesController::class, 'bulkActionServices'])->name('services.bulk');

    Route::crudRoutes('broadcast_categories', BroadcastCategoriesController::class);
    Route::crudRoutes('faqs', FAQSController::class);
    Route::crudRoutes('posts', PostsController::class);
    Route::crudRoutes('archives', ArchivesController::class);
    Route::crudRoutes('booked_appointments', BookedAppointmentsController::class);
    Route::crudRoutes('podcasts', PodcastsController::class);
    Route::crudRoutes('broadcasts', BroadcastsController::class);


    Route::dependentCrudRoutes('therapist_posts/{therapist}', TherapistPostsController::class);
    Route::dependentCrudRoutes('therapist_events/{therapist}', TherapistEventsController::class);
    Route::dependentCrudRoutes('therapist_educations/{therapist}', TherapistEducationsController::class);
    Route::dependentCrudRoutes('therapist_experiences/{therapist}', TherapistExperiencesController::class);
    Route::dependentCrudRoutes('therapist_certifications/{therapist}', TherapistCertificationsController::class);
    Route::dependentCrudRoutes('therapist_broadcasts/{therapist}', TherapistBroadcastsController::class);
    Route::dependentCrudRoutes('therapist_podcasts/{therapist}', TherapistPodcastsController::class);
    Route::dependentCrudRoutes('therapist_archives/{therapist}', TherapistArchivesController::class);

    //Therapist community
    Route::dependentCrudRoutes('therapist_community_posts/{therapist_community}', TherapistCommunityPostsController::class);
    Route::dependentCrudRoutes('therapist_community_events/{therapist_community}', TherapistCommunityEventsController::class);
    // Route::dependentCrudRoutes('therapist_community_educations/{therapist_community}', TherapistCommunityEducationsController::class);
    // Route::dependentCrudRoutes('therapist_community_experiences/{therapist_community}', TherapistCommunityExperiencesController::class);
    Route::dependentCrudRoutes('therapist_community_certifications/{therapist_community}', TherapistCommunityCertificationsController::class);
    Route::dependentCrudRoutes('therapist_community_broadcasts/{therapist_community}', TherapistCommunityBroadcastsController::class);
    Route::dependentCrudRoutes('therapist_community_podcasts/{therapist_community}', TherapistCommunityPodcastsController::class);
    Route::dependentCrudRoutes('therapist_community_archives/{therapist_community}', TherapistCommunityArchivesController::class);

    Route::prefix('therapists')->name('therapists.')->group(function () {
        Route::get('profile/{therapist}', [TherapistsController::class, 'profile'])->name('profile');
    });
    Route::prefix('therapist_communitys')->name('therapist_communitys.')->group(function () {
        Route::get('profile/{therapist_community}', [TherapistCommunitysController::class, 'profile'])->name('profile');
    });

    Route::crudRoutes('archive_categories', ArchiveCategoriesController::class);
    Route::crudRoutes('languages', LanguagesController::class);
    Route::get('download_sample', [LanguagesController::class, 'downloadSampleFile'])->name('download_sample.get');
    Route::crudRoutes('app_carousels', AppCarouselsController::class);
    Route::crudRoutes('countries', CountriesController::class);
    Route::crudRoutes('states', StatesController::class);
    Route::crudRoutes('cities', CitiesController::class);
    Route::get('/cities/listing',[CitiesController::class,'listCountries'])->name('cities.list');
    Route::get('cities_states', [AJAXController::class, 'getStatesByCountry'])->name('getStatesByCountry');
    Route::crudRoutes('pricing_plans', PricingPlansController::class);
    Route::post('pricing_plans_syn', [PricingPlansController::class, 'syncPlans'])->name('pricing_plans.sync');

    Route::crudRoutes('bank_accounts', BankAccountsController::class);
    Route::crudRoutes('bank_transactions', BankTransactionsController::class);
    Route::put('bank_transactions/{bank_transaction}/approve', [BankTransactionsController::class, 'approve'])->name('bank_transactions.approve');
    Route::put('bank_transactions-bulk/{type}', [BankTransactionsController::class, 'approveapprove'])->name('bank_transactions.bulk');



    Route::get('commission', [CommissionSettingsController::class, 'index'])->name('commission.index');
    Route::post('commission', [CommissionSettingsController::class, 'commissionUpdate'])->name('commission.update');

    // General Settings route
    Route::get('general_settings', [GeneralSettingsController::class, 'index'])->name('general_settings.index');
    Route::get('social_media_settings', [GeneralSettingsController::class, 'getSocialLinksSettings'])->name('specific_settings.social_media_settings');

    Route::get('payment_method_settings', [GeneralSettingsController::class, 'getPaymentMethodsSettings'])->name('specific_settings.payment_method_settings');


    Route::resource('notification_settings', NotificationSettingsController::class);


    Route::get('footer_settings', [GeneralSettingsController::class, 'getFooterSettings'])->name('specific_settings.footer_settings');
    Route::get('configurations', [GeneralSettingsController::class, 'getconfigurationsSettings'])->name('specific_settings.configurations');
    // Route::get('theme_settings', [GeneralSettingsController::class, 'getThemesSettings'])->name('specific_settings.themes');
    Route::get('email/configurations', [GeneralSettingsController::class, 'getEmailconfigurationsSettings'])->name('specific_settings.email.configurations');
    Route::get('home_page_statistics_settings', [GeneralSettingsController::class, 'getHomePageStatisticsSettings'])->name('specific_settings.home_page_statistics_settings');
    Route::get('clear_cache', [GeneralSettingsController::class, 'clearCache'])->name('clear_cache.index');
    Route::get('seo_settings', [GeneralSettingsController::class, 'seoSettings'])->name('seo_settings.index');


    Route::put('general_settings', [GeneralSettingsController::class, 'update'])->name('general_settings.update');
    Route::get('profile', [ProfileController::class, 'index'])->name('profile.index');
    Route::put('profile/{user}', [ProfileController::class, 'update'])->name('profile.update');
    Route::resource('roles', RolesController::class);
    Route::get('get_permissions_except_role', [RolesController::class, 'getPermissionsExceptRole'])->name('getPermissionsExceptRole');
    Route::get('view_notifications/{type}', [DashboardController::class, 'viewNotification'])->name('viewNotifications');

    // Content Pages
    Route::get('pages_contents/{section}', [PagesContentsController::class, 'getPageContent'])->name('pages_contents.get');
    Route::put('pages_contents', [PagesContentsController::class, 'update'])->name('pages_contents.update');

    Route::get('not_allowed', [DashboardController::class, 'notAllowed'])->name('not_allowed');

    //Contact
    Route::crudRoutes('contacts', ContactsController::class);


    Route::crudRoutes('gateways', GatewaysController::class);
    Route::crudRoutes('currencies', CurruncyController::class);
    Route::crudRoutes('withdraw_requests', WithdrawRequestsController::class);
    Route::get('version', [VersionUpgradesController::class, 'index'])->name('version_upgrade.index');
    Route::post('version_upgrade', [VersionUpgradesController::class, 'upgrade'])->name('version_upgrade.upgrade');


    Route::get('theme_settings', [ThemeSettingsController::class, 'index'])->name('theme_settings.index');
    Route::put('theme_settings', [ThemeSettingsController::class, 'update'])->name('theme_settings.update');
    Route::get('home_page_settings', [ThemeSettingsController::class, 'homeIndex'])->name('home_page.index');
    Route::put('home_page_settings', [ThemeSettingsController::class, 'homePage'])->name('home_page.update');
    Route::post('home_page_status_settings', [ThemeSettingsController::class, 'homePageStatus'])->name('home_page.status');

    Route::get('system_info',[SystemInformationsController::class, 'index'])->name('system_info.index');

    // Route::get('payment-methods', 'Admin\PaymentMethodController@index')->name('payment.methods');
    // Route::post('payment-methods/deactivate', 'Admin\PaymentMethodController@deactivate')->name('payment.methods.deactivate');
    // Route::get('payment-methods/deactivate', 'Admin\PaymentMethodController@deactivate')->name('payment.methods.deactivate');
    // Route::post('sort-payment-methods', 'Admin\PaymentMethodController@sortPaymentMethods')->name('sort.payment.methods');
    // Route::get('payment-methods/edit/{id}', 'Admin\PaymentMethodController@edit')->name('edit.payment.methods');
    // Route::put('payment-methods/update/{id}', 'Admin\PaymentMethodController@update')->name('update.payment.methods');
});
